/** @file   bonusobject.cpp
 * @brief   Implementation of BonusObject class
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/04/12 21:13:22 $
 * @author  Tomi Lamminsaari
 */

#include "bonusobject.h"
#include "GfxManager.h"
#include "www_map.h"
#include "GfxId.h"
#include "Resource/BonusObjects.rh"

using namespace eng2d;
using std::string;

namespace WeWantWar {

//********************************************************************
//                                                                   *
//      Static members and constants                                 *
//                                                                   *
//********************************************************************

const BonusObject::Type BonusObject::RIFLE;
const BonusObject::Type BonusObject::SHOTGUN;
const BonusObject::Type BonusObject::SNIPERRIFLE;
const BonusObject::Type BonusObject::GRENADE;
const BonusObject::Type BonusObject::ROCKETLAUNCHER;
const BonusObject::Type BonusObject::FIRSTAID;
const BonusObject::Type BonusObject::FLAMETHROWER;
const BonusObject::Type BonusObject::MINIGUN;
const BonusObject::Type BonusObject::UZI;
const BonusObject::Type BonusObject::EXTRALIFE;
const BonusObject::Type BonusObject::UNKNOWN;
const BonusObject::Type BonusObject::BODYARMOR;


const int BonusObject::spriteIndexArray[13] = {
  KBonus_Rifle,
  KBonus_Shotgun,
  KBonus_SniperRifle,
  KBonus_GrenadePack,
  KBonus_RocketLauncher,
  KBonus_FirstAid,
  KBonus_FlameThrower,
  KBonus_Minigun,
  KBonus_Uzi,
  KBonus_ExtraLife,
  KBonus_Bonus100Pts,
  KBonus_Bonus200Pts,
  KBonus_BodyArmor
};


/** Converts the given string to bonus type
 */
BonusObject::Type BonusObject::stringToType( const string& bn )
{
  if ( bn == "rifle" ) return RIFLE;
  if ( bn == "shotgun" ) return SHOTGUN;
  if ( bn == "grenade" ) return GRENADE;
  if ( bn == "firstaid" ) return FIRSTAID;
  if ( bn == "flamethrower" ) return FLAMETHROWER;
  if ( bn == "minigun" ) return MINIGUN;
  if ( bn == "uzi" ) return UZI;
  if ( bn == "extralife" ) return EXTRALIFE;
  if ( bn == "100pts" ) return SCORE_100PTS;
  if ( bn == "200pts" ) return SCORE_200PTS;
  if ( bn == "sniperrifle" ) return SNIPERRIFLE;
  if ( bn == "rocketlauncher" ) return ROCKETLAUNCHER;
  if ( bn == "bodyarmor" ) return BODYARMOR;
  return UNKNOWN;
}


//********************************************************************
//                                                                   *
//      Constructors, destructor and operators                       *
//                                                                   *
//********************************************************************

/** Constructor
 */
BonusObject::BonusObject(Type t) :
  m_type( t ),
  m_position( 0,0 ),
  m_size( 32 )
{
}



/** Destructor
 */
BonusObject::~BonusObject()
{
}



//********************************************************************
//                                                                   *
//      Public interface                                             *
//                                                                   *
//********************************************************************

/** Sets the position
 */
void BonusObject::position( const Vec2D& p )
{
  m_position = p;
}



/** Sets the radius of this object
 */
void BonusObject::size( float s )
{
  m_size = s;
}



/** Redraws this object
 */
void BonusObject::redraw( BITMAP* pTarget )
{
  RLE_SPRITE* sprite = GfxManager::findRleSprite( GfxId::KBonusImages,
                                                  spriteIndexArray[m_type] );
  int x = static_cast<int>( m_position.x() ) - Map::scrollX;
  int y = static_cast<int>( m_position.y() ) - Map::scrollY;
  x -= sprite->w/2;
  y -= sprite->h/2;
  draw_rle_sprite(pTarget, sprite, x,y); 
}



/** updates this object
 */
void BonusObject::update()
{
}



//********************************************************************
//                                                                   *
//      Public GET - methods                                         *
//                                                                   *
//********************************************************************

/** Returns the type of this object
 */
BonusObject::Type BonusObject::type() const
{
  return m_type;
}



/** Returns the position
 */
Vec2D BonusObject::position() const
{
  return m_position;
}



/** Returns the size of this object
 */
float BonusObject::size() const
{
  return m_size;
}



//********************************************************************
//                                                                   *
//      Private methods                                              *
//                                                                   *
//********************************************************************

} // end of namespace
